function design = ATLI_1BL_1d(n, d, ATLI_1BL)
%ATLI_1BL: Generates a 1D ATLI_1BL ARRAY.
%Syntax:
%   design = ATLI_1BL_1d(number_of_sensors, wavelength/2, 'Name');
%Inputs:
%   n - Number of sensors.
%   d - Inter-element spacing.
%   name - Name of the array.
%Outputs:
%   design - An array design struct.
if n <= 7
    error('Sensor amount must larger than 7.');
end
% ========= array configuration ============
% ========= decide spacing
n_1 = floor((n+4)/6);
if n_1<2
    n_1 = 2;
end
n_3 = n + 2 - 4*n_1;
sn_1 = 1;
%n_1 = 4;
sn_2 = 2 * n_1 - 1;
sn_3 = 2 * sn_2 + 1;
sn_4 = sn_2 + 1;
sn_5 = 1;
% === sub2 === %
% initial:7,2,6
% ʵ1:9,3,7
%sn_2 = 8;
n_2 = n_1 - 1;
interspace_12 = sn_1 * n_1;
i_2 = sn_1*(n_1-1) + interspace_12;
% === sub3 === %
% initial:10,4,1
% ʵ1:14,4,1
%sn_3 = 11;

interspace_23 = sn_2;
i_3 = i_2 + (n_2-1)*sn_2 + interspace_23;
% === sub4 === %
% initial:4,2,3
% ʵ1:5,3,4
%sn_4 = 5;
n_4 = n_2;
interspace_34 = sn_4;
i_4 = i_3 + (n_3-1)*sn_3 + interspace_34;
% === sub5 === %
% initial:3,2,2
% ʵ1:4,3,3
%sn_5 = 3;
n_5 = n_1;
interspace_45 = sn_4;
i_5 = i_4 + (n_4-1)*sn_4 + interspace_45;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub1 = [];
for sub1_count = 1:n_1
    sub1(sub1_count) = 0 + (sub1_count-1)*sn_1;
end

sub2 = [];
for sub2_count = 1:n_2
    sub2(sub2_count) = 0 + (sub2_count-1)*sn_2;
end
sub2 = sub2+i_2;
sub3 = [];
for sub3_count = 1:n_3
    sub3(sub3_count) = 0 + (sub3_count-1)*sn_3;
end
sub3 = sub3+i_3;
%%%%%%%%%%%%%%%%%%%%%%%%%
sub4 = [];
for sub4_count = 1:n_4
    sub4(sub4_count) = 0 + (sub4_count-1)*sn_4;
end
sub4 = sub4+i_4;
%%%%%%%%%%%%%%%%%%%%%%%%%%
sub5 = [];
for sub5_count = 1:n_5
    sub5(sub5_count) = 0 + (sub5_count-1)*sn_5;
end
sub5 = sub5+i_5;



if d <= 0 || ~isreal(d)
    error('d must be a positive real number.');
end
if nargin <= 2
    name = sprintf('ATLI-1BL %d sensors', n);
elseif ~ischar(name)
    error('Name must be a string.');
end
design.element_indices = [sub1 sub2 sub3 sub4 sub5];
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = 'ATLI-1BL';
design.name = name;
end